// fichier : F_externe_nD.h
// classe  : F_externe_nD


/************************************************************************
*            UNIVERSITE DE BRETAGNE SUD (UBS) --- LORIENT              *
************************************************************************
*           IRDL - Equipe DE GENIE MECANIQUE ET MATERIAUX (EG2M)       *
* Centre de Recherche Rue de Saint Maudé - 56325 Lorient cedex         *
* tel. 02.97.32.82.47                 http://IRDL.fr                   *
************************************************************************
 *     DATE:        4/03/2020                                           *
 *                                                                $     *
 *     AUTEUR:      G RIO   (mailto:gerard.rio@univ-ubs.fr)             *
 *                  phone  0297874573, fax : 0297874588                 *
 *                                                                $     *
 *     PROJET:      Herezh++                                            *
 *                                                                $     *
 ************************************************************************
 *     BUT:    exemple de fct nd externe                                *
 *             , définie par l'utilisateur, via 2 pipes nommés.         *
 *                                                                $     *
 *     ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''     * 
 *                                                                      *
 *     VERIFICATION:                                                    *
 *                                                                      *
 *     !  date  !   auteur   !       but                          !     *
 *     ------------------------------------------------------------     *
 *     !        !            !                                    !     *
 *                                                                $     *
 *     ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''     *
 *     MODIFICATIONS:                                                   *
 *     !  date  !   auteur   !       but                          !     *
 *     ------------------------------------------------------------     *
 *                                                                $     *
 ************************************************************************/
 
#ifndef FONCTION_EXTERNE_ND_H
#define FONCTION_EXTERNE_ND_H
# include <iostream>
#include <fstream>
using namespace std;  //introduces namespace std
#include <string.h>
#include <string>
#include <vector>



// définition d'une union qui lie les réels, les entiers et les caractères
union Tab_car_double_int_1
  {  char    tampon[928];
     double  x[116];
     int     n[232];
  } ;

class F_externe_nD
{
  public :

    // CONSTRUCTEURS :
    F_externe_nD();
    
    // DESTRUCTEUR :
    ~F_externe_nD();
    
    // METHODES PUBLIQUES :
    // changement de l'affichage
    void ChangeNiveauAffichage(int niveau)
      {permet_affichage=niveau;};
     
    // initialisation des pipes
    void InitialisationPipesNommes();
    // exécution de la Fonction
    void Execution() ;
 
    
  protected :  
    // VARIABLES PROTEGEES :
 
    
    // -- variables pour les tubes nommés ----------
    string nom;
    // nom du tube nommé pour l'envoi des données
    string envoi;
    // nom du tube nommé pour la reception des données
    string reception;

    Tab_car_double_int_1 t_car_x_n; // tableau de caractères, réels et entiers
    int permet_affichage;
    int nb_variable,nb_retour;
 
    // METHODES PROTEGEES :

       
    // lecture des données sur le pipe
    void LecturePipe();
    // écriture des résultats sur le pipe
    void EcriturePipe();



 };
 
#endif  
